Scriptname JBulk_MainQuest extends Quest  

Actor Property PlayerRef Auto
Keyword Property JBulk_Keyword_IsBulkEnchantToken Auto
ObjectReference Property WeaponContainer Auto Hidden
MagicEffect Property EnchFireDamageFFContact Auto

Keyword Property JBulk_Keyword_TokenPetty Auto
Keyword Property JBulk_Keyword_TokenLesser Auto
Keyword Property JBulk_Keyword_TokenCommon Auto
Keyword Property JBulk_Keyword_TokenGreater Auto
Keyword Property JBulk_Keyword_TokenGrand Auto
Keyword Property JBulk_Keyword_TokenBlack Auto

SoulGem Property SoulGemPettyFilled Auto
SoulGem Property SoulGemLesserFilled Auto
SoulGem Property SoulGemCommonFilled Auto
SoulGem Property SoulGemGreaterFilled Auto
SoulGem Property SoulGemGrandFilled Auto
SoulGem Property SoulGemBlackFilled Auto

MiscObject Property JBulk_Item_Dummy_OnCooldown Auto

int[] Property SOUL_GEM_SIZE Auto

;   Template arguments for CreateEnchantment()
MagicEffect[] templateEffects
Float[] templateMagnitudes
Int[] templateAreas
Int[] templateDurations

Function Log(String msg) global
	Debug.Trace(msg)
	Debug.Notification(msg)
EndFunction

;   Only when the player is inside the crafting menu and a BulkEnchantToken is added to the player.
Function OnItemAddedFunction(Form akBaseItem, int aiItemCount)
    if akBaseItem.HasKeyword(JBulk_Keyword_IsBulkEnchantToken)
        if !WeaponContainer
            Debug.MessageBox("No Weapon Chest was found. Bulk enchanting will not work.")
            return
        endif
        SoulGem soulGemType = None

        ; Determine used soul gem type
        if akBaseItem.HasKeyword(JBulk_Keyword_TokenPetty)
            soulGemType = SoulGemPettyFilled
        elseif akBaseItem.HasKeyword(JBulk_Keyword_TokenLesser)
            soulGemType = SoulGemLesserFilled
        elseif akBaseItem.HasKeyword(JBulk_Keyword_TokenCommon)
            soulGemType = SoulGemCommonFilled
        elseif akBaseItem.HasKeyword(JBulk_Keyword_TokenGreater)
            soulGemType = SoulGemGreaterFilled
        elseif akBaseItem.HasKeyword(JBulk_Keyword_TokenGrand)
            soulGemType = SoulGemGrandFilled
        elseif akBaseItem.HasKeyword(JBulk_Keyword_TokenBlack)
            soulGemType = SoulGemBlackFilled
        endif
        
        BulkEnchant(PlayerRef, WeaponContainer, soulGemType, aiItemCount)

        ; Remove token item
        PlayerRef.RemoveItem(akBaseItem, aiItemCount, true)
    endif
EndFunction

;   Adds enchantment ench to ref with a maximum charge of maxCharge
Function SetEnchantment(ObjectReference ref, Enchantment ench, float maxCharge)
    ; Cannot SetEnchantment on weapons without enchantments
    ref.CreateEnchantment(maxCharge, templateEffects, templateMagnitudes, templateAreas, templateDurations)
    ref.SetEnchantment(ench, maxCharge)
EndFunction

;   Enchants up to soulGemNumber weapons from weaponContainer using soulGemType
;   and the enchantment of the weapon in user's right hand.
;   user            - The actor whose right hand weapon's enchantment is used and to whom created items are given
;                   - Should generally be the player
;   weaponContainer - Weapons from this container will be enchanted
;   soulGemType     - The type of soul gems, which will be given to user, if not enough weapons could be enchanted
;                   - The soul gems are not removed from the user by this function (this should be done by crafting)
;   soulGemNumber   - The number of soul gems that were used in crafting or the number of wanted enchantments
Function BulkEnchant(Actor user, ObjectReference weaponContainer, SoulGem soulGemType, int soulGemNumber)
    ;float start = Utility.GetCurrentRealTime()
    bool break = false
    bool error = false
    Float soulGemSize = SOUL_GEM_SIZE[soulGemType.GetSoulSize()]
    Enchantment weaponEnch = WornObject.GetEnchantment(user, 1, 0)
    String weaponName = WornObject.GetDisplayName(user, 1, 0)
    if !weaponEnch
        Debug.MessageBox("Equip a player enchanted weapon in your right hand.")
        break = true
        error = true
    endif
    int itemsEnchanted = 0
    while !break
        Form item = weaponContainer.GetNthForm(0)
        if !item
            break = true
        else
            Weapon itemWeapon = item as Weapon
            if itemWeapon
                if itemWeapon.GetEnchantment() == None ; Weapon Form has no enchantment
                    ; Enchant item
                    ObjectReference ref = weaponContainer.DropObject(itemWeapon)

					; Ensure item has no player enchantment
					if ref.GetEnchantment() == None
						SetEnchantment(ref, weaponEnch, soulGemSize)
						ref.SetDisplayName(ref.GetDisplayName() + " (" + weaponName + ")", false)
						itemsEnchanted += 1
					endif

                    user.AddItem(ref, 1, true)
                    if itemsEnchanted >= soulGemNumber
                        break = true
                    endif
                else
                    ; Already enchanted
                    weaponContainer.RemoveItem(item, 1, true, user)
                endif
            else
                ; Not a weapon
                weaponContainer.RemoveItem(item, 1, true, user)
            endif
        endif
    endwhile

    if itemsEnchanted > 0
        Game.AdvanceSkill("Enchanting", 1 * itemsEnchanted)
        Debug.Notification(itemsEnchanted + " weapons have been enchanted.")
    endif

    ; Too few weapons: Notify player and add soul gems back
    if soulGemNumber - itemsEnchanted > 0
        if !error
            Debug.MessageBox("Not enough weapons to enchant. Unused soul gems are added to your inventory.")
        endif
        user.AddItem(soulGemType, soulGemNumber - itemsEnchanted , true)
    endif

    ;float time = Utility.GetCurrentRealTime() - start
    ;Debug.Trace("BulkEnchant(PlayerRef, WeaponContainer, soulGemType, " + soulGemNumber + ") took " + time + "seconds.")
    user.AddItem(JBulk_Item_Dummy_OnCooldown, 1, true)
EndFunction

;   OnInit() + OnPlayerLoadGame()
Function Maintenance()
    
EndFunction

Event OnInit()
    PlayerRef.AddItem(JBulk_Item_Dummy_OnCooldown, 1, true)
    templateEffects = new MagicEffect[1]
    templateMagnitudes = new Float[1]
    templateAreas = new Int[1]
    templateDurations = new Int[1]
    
    templateEffects[0] = EnchFireDamageFFContact
    templateMagnitudes[0] = 1
    templateAreas[0] = 0
    templateDurations[0] = 0
EndEvent